using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace SMAT_CE
{
    public partial class uc_MonitorDataChina : UserControl
    {
        private int _wVNAPanelHeight;
        string path = "";
        public uc_MonitorDataChina()
        {
            InitializeComponent();

            _wVNAPanelHeight = pnlwVNA.Height;
            txtwVNAWeight.Text = "0.5";

            Toggle();
            return;
        }

        /// <summary>
        /// Initialize Control
        /// add by Devin
        /// 20191119
        /// </summary>
        public void InitializeControl()
        {
            if ((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina == null)
            {
                (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina = new MonitorDataInputChina();
                rbtnQuarterlyMonitorChina.Checked = true;
                rbtnDailyMonitorChina.Checked = false;
                choIAdjustedFRMChina.Checked = false;
                choIFRMChina.Checked = false;
                chkwVNA.Checked = false;
                chkwVNAAdvance.Checked = false;
                chkNS.Checked = false;
                cboEndYearChina.Items.Clear();
                cboStartYearChina.Items.Clear();
                if (CommonClass.dicExampleConfiguration != null)
                {
                    CommonClass.monitorFile = CommonClass.dicExampleConfiguration["AnnualPM"]["PMMonitorDataFile"]; //Application.StartupPath + @"\Data\SampleData\SMAT-China\ʡPM25㼾Ⱦֵ.csv";
                    txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
                    CommonClass.getmonitorYear("");
                    int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                    int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                    for (int i = start; i <= end; i++)
                    {
                        cboEndYearChina.Items.Add(i);
                        cboStartYearChina.Items.Add(i);
                    }
                    cboStartYearChina.SelectedIndex = 0;
                    cboEndYearChina.SelectedIndex = end - start;
                }
            }
            else
            {
                rbtnDailyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doDailyMonitorDataInput;
                rbtnQuarterlyMonitorChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doQuarterlyMonitorDataInput;
                choIAdjustedFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateAdjustedFRM;
                choIFRMChina.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doInterpolateFRM;
                chkwVNA.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNA;
                chkwVNAAdvance.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.dowVNAAdvancedOption;
                txtwVNAWeight.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.wVNAWeight.ToString();
                chkNS.Checked = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.doNS;                
                CommonClass.monitorFile = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataInputFile;
                txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
                cboStartYearChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear;
                cboEndYearChina.Text = (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear;

                int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                for (int i = start; i <= end; i++)
                {
                    cboEndYearChina.Items.Add(i);
                    cboStartYearChina.Items.Add(i);
                }
                cboStartYearChina.SelectedIndex = 0;
                cboEndYearChina.SelectedIndex = end - start;
            }
         
        }

        private void btnOfficialMonitorChina_Click(object sender, EventArgs e)
        {
            try
            {
                OpenFileDialog open = new OpenFileDialog();
                if (string.IsNullOrEmpty(path) || !System.IO.Directory.Exists(path))
                {
                    if (string.IsNullOrEmpty(CommonClass.monitorFile) || !System.IO.Directory.Exists(Path.GetDirectoryName(CommonClass.monitorFile)))
                    {
                        open.InitialDirectory = Application.StartupPath + @"\Data\SampleData\";
                    }
                    else
                    {
                        open.InitialDirectory = Path.GetDirectoryName(CommonClass.monitorFile);
                    }
                }
                else
                    open.InitialDirectory = path;
                open.Title = LanguageOld.Translate("Select file...");
                open.Filter = LanguageOld.Translate("CSV Files(*.csv)|*.csv");
                if (open.ShowDialog() == DialogResult.OK)
                {
                    CommonClass.monitorFile = open.FileName;
                    txtOfficialMonitorChina.Text = Path.GetFileName(open.FileName);
                    path = Path.GetDirectoryName(open.FileName);
                    open.RestoreDirectory = true;

                    //------add Years to cbox------
                    cboEndYearChina.Items.Clear();
                    cboStartYearChina.Items.Clear();
                    bool GetYears = CommonClass.getmonitorYear("");
                    if (!GetYears)
                    {
                        MessageBox.Show("Monitor Data is ill-formatted data!");
                    }
                    else
                    {
                        int start = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataStartYear);
                        int end = Convert.ToInt16((CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.MonitorDataEndYear);
                        //for (int i = start; i <= end; i++)
                        //{
                        //    cboEndYearChina.Items.Add(i);
                        //    cboStartYearChina.Items.Add(i);
                        //}
                        foreach (var item in (CommonClass.CurrentBaseScenario.configuration as AnnualPMAnalysisChinaConfiguration).monitorDataInputChina.lstMonitorYears)
                        {
                            cboEndYearChina.Items.Add(item);
                            cboStartYearChina.Items.Add(item);
                        }
                        cboStartYearChina.SelectedIndex = 0;
                        cboEndYearChina.SelectedIndex = end - start;
                    }
                }
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }           
        }

        private void rbtnQuarterlyMonitorChina_CheckedChanged(object sender, EventArgs e)
        {
            if (rbtnDailyMonitorChina.Checked == true)
            {
                CommonClass.monitorFile = "";
                txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
            }
            else if (rbtnQuarterlyMonitorChina.Checked == true)
            {
                CommonClass.monitorFile = Application.StartupPath + @"\Data\SampleData\SMAT-China\PM25_Mass_Data_Quaterly_2013_YRD.csv";
                txtOfficialMonitorChina.Text = Path.GetFileName(CommonClass.monitorFile);
            }
        }

        private void Toggle()
        {
            Toggle_wVNA();
        }

        private void Toggle_wVNA()
        {
            if (chkwVNA.Checked)
            {
                pnlwVNA.Visible = true;
                choIFRMChina.Checked = true;
                choIAdjustedFRMChina.Checked = true;
                if (chkwVNAAdvance.Checked)
                {
                    pnlwVNAAdvanced.Visible = true;
                    pnlwVNA.Height = _wVNAPanelHeight;
                }
                else
                {
                    pnlwVNAAdvanced.Visible = false;
                    pnlwVNA.Height = _wVNAPanelHeight - pnlwVNAAdvanced.Height;
                }
            }
            else
            {
                pnlwVNA.Visible = false;
                pnlwVNA.Height = 0;
            }

            chkNS.Location = new Point(chkNS.Location.X, pnlwVNA.Location.Y + pnlwVNA.Height);
        }

        private void chkwVNA_Click(object sender, EventArgs e)
        {
            Toggle();
            return;

            // wVNAVNAeVNAۺ
            if (chkwVNA.Checked)
            {
                choIFRMChina.Checked = true;
                choIAdjustedFRMChina.Checked = true;
            }
            pnlwVNA.Visible = chkwVNA.Checked;
            pnlwVNAAdvanced.Visible = chkwVNAAdvance.Checked;
        }

        private void chkwVNAAdvance_Click(object sender, EventArgs e)
        {
            Toggle();
            return;
            pnlwVNAAdvanced.Visible = chkwVNAAdvance.Checked;
        }

        private void txtwVNAWeight_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == 0x20) e.KeyChar = (char)0;  //ֹո

            //if (e.KeyChar == (char)46) e.KeyChar = (char)0;

            if ((e.KeyChar == 0x2D) && (((TextBox)sender).Text.Length == 0)) return;   //

            if (e.KeyChar > 0x20)
            {
                double result = 0;
                if (!double.TryParse(((TextBox)sender).Text + e.KeyChar.ToString(), out result))
                {
                    e.KeyChar = (char)0;
                }
            }
        }
    }
}
